using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;

namespace EQTrack
{
	public class XMLSettings : XmlDocument
	{
		public string SettingsName = "";

		public XMLSettings(string SettingsName)
		{
			this.SettingsName = SettingsName;
			this.AppendChild(this.CreateElement(SettingsName));
		}

		public void Set(string Path, object Value)
		{
			string[] PathData = Path.Split('\t');
			if (PathData.Length > 0)
			{
				XmlNode ThisNode = this.DocumentElement;
				for (int i = 0; i < PathData.Length; i++)
				{
					string ThisNodeName = XmlConvert.EncodeName(PathData[i]);
					XmlNode NextNode = ThisNode[ThisNodeName];
					if (NextNode == null)
					{
						NextNode = this.CreateElement(ThisNodeName);
						ThisNode.AppendChild(NextNode);
					}
					ThisNode = NextNode;
				}
				if (Value == null)
				{
					((XmlElement)ThisNode).SetAttribute("Type", "NULL");
					((XmlElement)ThisNode).SetAttribute("Value", "NULL");
				}
				else
				{
					((XmlElement)ThisNode).SetAttribute("Type", Value.GetType().Name);
					((XmlElement)ThisNode).SetAttribute("Value", Value.ToString());
				}
			}
		}

		public XmlNode Find(string Path)
		{
			string[] PathData = Path.Split('\t');
			if (PathData.Length > 0)
			{
				XmlNode ThisNode = this.DocumentElement;
				for (int i = 0; i < PathData.Length && ThisNode != null; i++)
				{
					string ThisNodeName = XmlConvert.EncodeName(PathData[i]);
					ThisNode = ThisNode[ThisNodeName];
				}
				return ThisNode;
			}
			return null;
		}

		public bool Exists(string Path)
		{
			return Find(Path) != null;
		}

		public string[] GetNames(string Path)
		{
			List<string> Names = new List<string>();
			XmlNode ThisNode = Find(Path);
			if (ThisNode != null)
			{
				foreach (XmlNode ThisChildNode in ThisNode.ChildNodes)
					Names.Add(XmlConvert.DecodeName(ThisChildNode.Name));
			}
			return Names.ToArray();
		}

		public object GetValue(string Path)
		{
			try
			{
				XmlNode ThisNode = Find(Path);
				if (ThisNode != null)
				{
					string Value = ThisNode.Attributes["Value"].InnerText;
					switch (ThisNode.Attributes["Type"].InnerText)
					{
						case "Boolean":
							return Boolean.Parse(Value);

						case "Byte":
							return Byte.Parse(Value);

						case "Char":
							return Char.Parse(Value);

						case "Int16":
							return Int16.Parse(Value);

						case "Int32":
							return Int32.Parse(Value);

						case "Single":
							return Single.Parse(Value);

						case "Double":
							return Double.Parse(Value);

						case "DateTime":
							return DateTime.Parse(Value);

						case "NULL":
							return null;

						default:
							return Value;
					}
				}
			}
			catch { }
			return null;
		}

		public string GetString(string Path, string DefaultValue)
		{
			object Value = GetValue(Path);
			if (Value != null && Value.GetType().Equals(typeof(string)))
				return (string)Value;
			return DefaultValue;
		}

		public int GetInt(string Path, int DefaultValue)
		{
			object Value = GetValue(Path);
			if (Value != null && Value.GetType().Equals(typeof(int)))
				return (int)Value;
			return DefaultValue;
		}

		public float GetFloat(string Path, float DefaultValue)
		{
			object Value = GetValue(Path);
			if (Value != null && Value.GetType().Equals(typeof(float)))
				return (float)Value;
			return DefaultValue;
		}

		public bool GetBool(string Path, bool DefaultValue)
		{
			object Value = GetValue(Path);
			if (Value != null && Value.GetType().Equals(typeof(bool)))
				return (bool)Value;
			return DefaultValue;
		}

		public DateTime GetDateTime(string Path, DateTime DefaultValue)
		{
			object Value = GetValue(Path);
			if (Value != null && Value.GetType().Equals(typeof(DateTime)))
				return (DateTime)Value;
			return DefaultValue;
		}

		public override void Load(string filename)
		{
			try
			{
				base.Load(filename);
			}
			catch
			{
				this.AppendChild(this.CreateElement(this.SettingsName));
			}
		}
	}
}
